/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import jemu.core.Util;
import jemu.core.device.Device;
import jemu.core.device.Register;

public class ERegisters
extends JPanel {
    protected Font fixed;
    protected Device device;

    public void setDevice(Device value) {
        this.device = value;
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.setFont(this.getFont());
        if (this.device != null) {
            int i;
            Register[] regs = this.device.getRegisters();
            int y = -1;
            int cols = 1;
            for (i = 0; i < regs.length; ++i) {
                cols = Math.max(cols, regs[i].getColumn() + 1);
            }
            for (i = 0; i < regs.length; ++i) {
                Register reg = regs[i];
                String fmt = reg.getFormat();
                int col = reg.getColumn() * 2;
                if (col == 0) {
                    ++y;
                }
                int w = 1;
                JLabel label = new JLabel(reg.getName());
                GridBagConstraints gridBagConstraints = new GridBagConstraints(col, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 1, 2, 1), 0, 0);
                if (fmt != null) {
                    this.setBorder(BorderFactory.createTitledBorder("Z80 Registers"));
                    gridBagConstraints = new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 1, 2, 1), 0, 0);
                    this.add((Component)new JLabel(fmt), gridBagConstraints);
                    gridBagConstraints = new GridBagConstraints(col, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 1, 2, 1), 0, 0);
                }
                this.add((Component)label, gridBagConstraints);
                JTextField tf = new JTextField();
                tf.setDoubleBuffered(true);
                tf.setHorizontalAlignment(0);
                tf.setBorder(new EtchedBorder());
                tf.setFont(this.fixed);
                gridBagConstraints = new GridBagConstraints(col + 1, y, w, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0);
                this.add((Component)tf, gridBagConstraints);
            }
            GridBagConstraints gbc = new GridBagConstraints(0, y + 1, 2, 1, 0.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)new JLabel(), gbc);
        }
        this.setValues();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fixed = new Font("Monospaced", 0, font.getSize());
    }

    public void setValues() {
        Component[] comp = this.getComponents();
        Register[] regs = this.device.getRegisters();
        int index = 0;
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof JTextField)) continue;
            Register reg = regs[index];
            String fmt = reg.getFormat();
            String str = "";
            int w = 0;
            if (fmt != null) {
                str = "0000000000000000" + Integer.toBinaryString(this.device.getRegisterValue(index));
                w = reg.getBits();
            } else {
                str = "000000000000000" + Util.hex(this.device.getRegisterValue(index));
                w = (reg.getBits() + 3) / 4;
            }
            String stt = str.substring(str.length() - w);
            int l = stt.length();
            switch (l) {
                case 2: {
                    ((JTextField)comp[i]).setColumns(3);
                    break;
                }
                case 4: {
                    ((JTextField)comp[i]).setColumns(5);
                    break;
                }
                default: {
                    ((JTextField)comp[i]).setColumns(9);
                }
            }
            ((JTextField)comp[i]).setText(stt);
            ++index;
        }
    }
}

